//package globalExamples;

import oracle.olapi.data.source.DataProvider;

import oracle.olapi.metadata.mdm.MdmMeasure;

import oracle.olapi.metadata.mtm.MtmColumnExpression;
import oracle.olapi.metadata.mtm.MtmMeasureMap;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;
import oracle.olapi.metadata.mtm.MtmRdbmsTableOrView;
import oracle.olapi.metadata.mtm.MtmUnsolvedCube;

import java.util.List;
import java.util.Iterator;

/**
 * Complete code for Example 5-3, Getting the Columns for an  MdmMeasure,
 * in Chapter 5, Working with Metadata Mapping Objects, the Oracle OLAP
 * Developer's Guide to the OLAP API.
 *
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 *
 * @author Oracle Corporation
 */
public class GettingColumnsForMeasure
{
  public GettingColumnsForMeasure()
  {
  }

  public void run(String [] args)
  {
    Context10g context = new Context10g(args, false);

    context.println("Example 5-3, Getting the Columns for an MdmMeasure\n");

    MdmMeasure mdmUnits = context.getMdmMeasureByName("UNITS");

    MtmMeasureMap mtmMeasMap = mdmUnits.getMeasureMap();
    MtmPartitionedCube mtmPCube = (MtmPartitionedCube)mtmMeasMap.getCube();
    List baseCubes = mtmPCube.getBaseCubes();
    MtmUnsolvedCube mtmFirstUCube = (MtmUnsolvedCube) baseCubes.get(0);
    MtmRdbmsTableOrView mtmRdbmsTorV =
                           (MtmRdbmsTableOrView) mtmFirstUCube.getTable();

    context.println("The name of the table is " + mtmRdbmsTorV.getName());

    List columns = mtmRdbmsTorV.getColumns();
    Iterator colItr = columns.iterator();

    context.println("Its columns are:");

    while (colItr.hasNext())
    {
       MtmColumnExpression mtmColExpr = (MtmColumnExpression) colItr.next();
       context.println(mtmColExpr.getColumnName());
    }
  }

  public static void main(String[] args)
  {
    new GettingColumnsForMeasure().run(args);
  }
}
